let wakeLock = null;

async function requestWakeLock() {
  try {
    wakeLock = await navigator.wakeLock.request('screen');
    console.log('Wake lock activat');
  } catch (err) {
    console.error(`${err.name}, ${err.message}`);
  }
}

window.onload = () => {
  requestWakeLock();

  const car = document.getElementById("car");

  if ("geolocation" in navigator) {
    navigator.geolocation.watchPosition(
      (position) => {
        const lat = position.coords.latitude;
        const lon = position.coords.longitude;

        const mapWidth = window.innerWidth;
        const mapHeight = 1024;

        // Coordonatele pentru Galați - centru
        const centerLat = 44.999194; 
        const centerLon = 27.056897;
        
        // Ajustează scala
        const scale = 398.36;

        // Calculul coordonatelor X și Y
        const x = mapWidth / 2 + (lon - centerLon) * scale;
        const y = mapHeight / 2 + (lat - centerLat) * scale;  // Am corectat semnul pentru Y

        // Verifică coordonatele și poziționează pinul
        console.log(`Coordonate GPS: ${lat}, ${lon} -> Pixeli: x=${x}, y=${y}`);

        // Verifică dacă pinul este în interiorul hărții
        if (x >= 0 && x <= mapWidth && y >= 0 && y <= mapHeight) {
          car.style.left = `${x}px`;
          car.style.top = `${y}px`;
          car.style.display = "block";
        } else {
          console.log("Pinul este în afara hărții!");
        }
      },
      (error) => {
        alert("Eroare la obținerea locației: " + error.message);
      },
      { enableHighAccuracy: true }
    );
  } else {
    alert("Browserul nu suportă geolocația.");
  }
};
